#!/bin/python
import RPi.GPIO as GPIO # importeer de GPIO bibliotheek.
from time import sleep # importeer de time biblotheek voor tijdfuncties.

GPIO.setmode(GPIO.BCM) # Zet de pinmode op Broadcom SOC.
GPIO.setwarnings(False) # Zet waarschuwingen uit.

led=5 # GPIO pin als LED variabele declareren
pir=16 # GPIO pin als PIR variabele declareren
buzzer=18 # GPIO pin als BUZZER variabele declareren

GPIO.setup(buzzer, GPIO.OUT) # Zet de BUZZER pin als uitgang
GPIO.setup(led, GPIO.OUT) # Zet de LED pin als uitgang
GPIO.setup(pir, GPIO.IN) # Zet de PIR pin als ingang


def alarm(duur,pauze):
        GPIO.output(led, 1) # zet de GPIO pin van de LED poort hoog (1 = licht aan)
        GPIO.output(buzzer,1) # zet de GPIO pin van de BUZZER poort hoog (1 = piepen)
        print("alarm duur" ,duur, "pauze" ,pauze )
        sleep(duur) # wachten (duur)
        GPIO.output(led, 0) # zet de GPIO pin van de LED poort laag (0 = licht uit)
        GPIO.output(buzzer, 0)# zet de GPIO pin van de BUZZER poort laag (0 = piepen uit)
        sleep(pauze) # wachten (pauze)


while True:

    if GPIO.input(pir)== 0: # als GPIO pin van de PIR poort laag (0 = geen beweging) is
        alarm(0.01,2)
        print("PIR = 0, geen beweging...") # print tekst

    else:
        alarm(0.01,0.1)
        print("PIR <> 0, wel beweging...") # print tekst
        
